<?

require_once('PgSQLQuery.php');
require_once('MySQLQuery.php');

Class TaskPlannerDB
{
	var $db;
	
	/* constructeur */
	function TaskPlannerDB($db)
	{
		$this->db = $db;
	}

	/* ajouter un projet ou une tche  la base de donnes */
	function AddTask($parenttask, $taskname, $projectindicator, $priority, $status, $deadline, $description)
	{
	    /* prparer une requte SQL qui ajoutera des informations sur le nouveau projet ou la nouvelle tche  la base de donnes */
	    $query = sprintf(
"insert into tblTask(parenttask, taskname, projectindicator, priority, status, deadline, description)
values(%d, '%s', '%d', %s, %s, %s, '%s')", $parenttask, $taskname, $projectindicator, $priority == null ? "null" : $priority, $status == null ? "null" : $status, $deadline == null ? "null" : "'".$deadline."'", $description);

	    /* effectuer la requte prpare */
	    $this->db->Execute($query);
	    
	    return $query;
	}
	
	/* supprimer un projet ou une tche de la base de donnes et supprimer les sous-tches et sous-projets de la manire rcursive */
	function DeleteTask($taskId)
	{
	    /* prparer une requte qui retourne touts les sous-projets et les sous-tches pour un projet donn */
	    $query = sprintf("select id from tblTask where parenttask = %d ", $taskId);

	    /* effectuer la requte prpare  */
	    $resultset = $this->db->ExecuteResultSet($query);	    
	    
	    $numRows = $this->db->GetNumRows($resultset);
	    
	    /* supprimer tous les sous-projets et les sous-tches pour le projet courant */
	    for($rowIdx = 0; $rowIdx < $numRows; $rowIdx++)
	    {    	    	    
	        $this->DeleteTask($this->db->GetScalar($resultset, $rowIdx, 0));
	    }
	    
	    /* prparer une requte SQL qui supprime le projet ou la tche courant  */
	    $query = sprintf("delete from tblTask where id = %d", $taskId);
	    
	    /* effectuer la requte */
	    $this->db->Execute($query);
	}
	
	/* tlcharger le document XML, cr au moyen de la rcursivit, qui dcrit les projets et les tches  */
	function GetTasks($parentTaskId = NULL)
	{
	    /* prparer une requte SQL qui retourne les projets et les tches pour un projet suprieur donn*/
	    $query = sprintf("select t.id, t.taskname, t.projectindicator, t.deadline, t.description, s.id as statusid, s.status, p.id as priorityid, p.priority from tblTask t left join tblStatus s on t.Status = s.Id left join tblPriority p on t.priority = p.Id where t.parenttask %s", $parentTaskId == NULL ? " is NULL" : " = ".$parentTaskId);
	    
	    /* effectuer la requte */
	    $resultset = $this->db->ExecuteResultSet($query);

	    $numRows = $this->db->GetNumRows($resultset);
	    	    
	    /* gnrer les nuds contenant les informations sur les projets et les tches et appeler la fonction GetTasks de la manire rcursive pour ajouter les informations sur les sous-projets et les sous-tches */
	    for($rowIdx = 0; $rowIdx < $numRows; $rowIdx++)
	    {    	    	    
	        $taskXml .= "<task ".$this->db->GenerateRowAttribs($resultset, $rowIdx)." >".$this->GetTasks($this->db->GetScalar($resultset, $rowIdx, 0))."</task>";
	    }
	    
	    return $taskXml;
	}

	/* actualiser les informations sur le projet ou la tche */
	function UpdateTask($taskId, $taskname, $projectindicator, $priority, $status, $deadline, $description)
	{
/* prparer une requte SQL qui actualise les informations sur le projet ou la tche */	
 $query = sprintf(
"update tblTask set 
    taskname = '%s',
     projectindicator = '%s', 
     priority = %s, 
     status = %s, 
     deadline = %s, 
     description = '%s'
where 
    id = %s", $taskname, $projectindicator, $priority == null ? "null" : $priority, $status == null ? "null" : $status, $deadline == null ? "null" : "'".$deadline."'", $description, $taskId);
    
	    /* effectuer la requte */
	    $this->db->Execute($query);	
	}
	
/* fonctions non utilises dans la version actuelle */	
	function GetPriorities()
	{
	    return $this->db->ExecuteXml("select * from tblPriority");
	}
	
	function GetStatuses()
	{
	    return $this->db->ExecuteXml("select * from tblStatus");
	}
}
?>
