var tasksXmlDoc; 	// document xml dcrivant l'arbre de projets et de tches
var currentProjectIdx;	// identifiant du projet slectionn actuellement 
var projectTreeView;	// objet de la vue de l'arbre de projets


var taskPlannerServer = "localhost"; //nom du serveur o se trouve le service Web taskplanner
var lang ="fr";

// fonctions de l'interface
// initialisation de l'interface
function initialize() {
	// chargement du document xml dcrivant l'arbre de projets
	tasksXmlDoc = loadXmlFromString(getTasks());
	// initialisation de l'arbre de projets selon le document xml charg
	initializeProjectTree();
}

function initializeProjectTree() {
	try {
		currentProjectIdx = -1;
		
		//dfinition de l'objet de la vue de l'arbre de projets
		treeView = {

			//nombre des lignes (projets)
			rowCount : getProjectCount(),
			//description de chaque nud
			getCellText : function(row, column) {
				return tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (row + 1)+ "]/@taskname", tasksXmlDoc, null, 2, null).stringValue;
			},

			//information si le nud contient d'autres nuds (vu l'implmentation simplifie de l'arbre, c'est toujours faux)
			isContainer: function(row) { 
				return false;
			},

			// information si un nud derrire le nud courant existe au mme niveau
			hasNextSibling: function(row) {
				return tasksXmlDoc.evaluate("count((//task[@projectindicator = 1])[" + (row + 1) + "]/following-sibling::*[@projectindicator = 1])", tasksXmlDoc, null, 1, null).numberValue > 0;
			},

			//index du nud qui est parent du nud courant
			getParentIndex : function getParentIndex(row) { 

				var parentProjectId = tasksXmlDoc.evaluate("//task[task[@id = (//task[@projectindicator = 1])[" + (row + 1) + "]/@id]]/@id", tasksXmlDoc, null, 1, null).numberValue;
				return tasksXmlDoc.evaluate("count((//task[descendant::*[@id = " + parentProjectId + " ] or following::*[@id = " + parentProjectId + "]])[@projectindicator = 1])", tasksXmlDoc, null, 1, null).numberValue;
			},

			//est-ce que le nud est un sparateur (vu l'implmentation simplifie de l'arbre, c'est toujours faux )
			isSeparator: function(row) { return false; },

			// est-ce que le nud est tri (vu l'implmentation simplifie de l'arbre, c'est toujours faux)
			isSorted: function(row) { return false; },

			//niveau d'imbrication du nud
			getLevel: function(row) { 
				return tasksXmlDoc.evaluate("count((//task[@projectindicator = 1])[" + (row + 1) + "]/ancestor::*)", tasksXmlDoc, null, 1, null).numberValue;
			},

			//image qui devrait s'afficher pour le nud courant (vu l'implmentation simplifie de l'arbre, c'est toujours null)
			getImageSrc: function(row,col){ return null; },
			
			//proprits de la ligne
			getRowProperties: function(row,props){},

			//proprits du  nud
			getCellProperties: function(row,col,props){},

			//proprits de la colonne
			getColumnProperties: function(colid,col,props){},

			//il n'est possible de choisir qu'un seul nud  la fois 
			selType : 'single',
		};

		//affichage de l'objet cr de l'arbre de projets
		document.getElementById('project-tree').view = projectTreeView = treeView;
	} catch(e) {
		alert(e);
	}
}

//affichage des tches pour un projet slectionn
function showTasksForProject(projectIdx) {

	try {
		currentProjectIdx = projectIdx;

		//dfinir l'objet de la vue de la liste de tches
		var treeView = {
			
			//nombre des lignes (tches)
			rowCount : getTaskCountForCurrentProject(currentProjectIdx),

    			setTree: function(treebox) { this.treebox=treebox; },
	
			//affichage du nom de la tche
			getCellText : function(row, column) {
				return tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (currentProjectIdx + 1) + "]/task[@projectindicator = 0][" + (row + 1) + "]/@" + column, tasksXmlDoc, null, 2, null).stringValue;
			},

			// information si la ligne donne contient d'autres lignes
			isContainer: function(row) { return false; },

			// information si la ligne donne est un sparateur
			isSeparator: function(row) { return false; },

			// information si la ligne donne est trie
			isSorted: function(row) { return false; },

			// information concernant le niveau d'imbrication
			getLevel: function(row) { return 0; },

			//image qui devrait s'afficher pour la ligne courante
			getImageSrc: function(row,col){ return null; },

			// proprits de la ligne 
			getRowProperties: function(row,props){},

			// proprits de l'lment
			getCellProperties: function(row,col,props){},

			// proprits de la colonne
			getColumnProperties: function(colid,col,props){},
		};

		//affichage de l'objet cr de la liste de tches 
		document.getElementById("task-tree").view=treeView;

	} catch(e) {
		alert(e);
	}
}

//rafrachir l'interface 
function refreshProjectTree(projectIdx) {
	//chargement du document dcrivant l'arbre de projets et l'affichage de l'arbre
	initialize();
	
	// affichage de la liste de tches pour le projet slectionn actuellement 
	showTasksForProject(projectIdx)

	//description du projet slectionn actuellement
	showProjectDescription(projectIdx);

	//surbrillance du nud du projet slectionn actuellement dans l'arbre de projets
	projectTreeView.selection.select(projectIdx);
}

//supprimer la tche
function doDeleteTask(projectIdx, taskIdx) {
	//supprimer la tche
	deleteTask(tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (projectIdx + 1) + "]/task[@projectindicator = 0][" + (taskIdx + 1) + "]/@id", tasksXmlDoc, null, 1, null).numberValue); 
	// rafrachir l'interface
	refreshProjectTree(currentProjectIdx); 
}

//supprimer le projet
function doDeleteProject(projectIdx) {
	//supprimer le projet
	deleteTask(tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (projectIdx + 1)+ "]/@id", tasksXmlDoc, null, 1, null).numberValue); 
	//rafrachir l'interface
	refreshProjectTree(currentProjectIdx); 	
}

//fonctions charges de communiquer avec le service Web

//charger l'arbre de projets et de tches 
function getTasks() {

	//ajouter le droit de communiquer avec le service Web pendant l'appel de cette fonction
	try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
	} catch (e) {
		alert(e);
		return null;
	}

	try
	{
		//crer un objet SOAPCall permettant de communiquer avec le service Web
		var soapCall = new SOAPCall();
		soapCall.transportURI = "http://" + taskPlannerServer + "/taskplanner/"+lang+"/TaskPlannerWS.php";

		//crer un tableau de paramtres transmis  la fonction
		var params = [new SOAPParameter(-1, "parentTaskId")];

		//appeler la fonction dans le service Web
		soapCall.encode(0, "GetTasks", null, 0, null, params.length, params);
		var result = soapCall.invoke();

		//rcuprer le rsultat retourn par le service Web
		var num = new Object();
		var r = result.getParameters(false, num);
 

		//retourner le rsultat reu par le service Web pour l'application 
		return r[0].value;


	} catch(e) {
		alert(e);
	}	
}

//ajouter une tche ou un projet 
function addTask(parentTaskId, taskName, projectIndicator, priority, status, deadline, description) {

	//ajouter le droit de communiquer avec le service Web pendant l'appel de cette fonction
	try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
	} catch (e) {
		alert(e);
		return null;
	}


	try
	{
		//crer un objet SOAPCall permettant de communiquer avec le service Web
		var soapCall = new SOAPCall();
		soapCall.transportURI = "http://" + taskPlannerServer + "/taskplanner/"+lang+"/TaskPlannerWS.php";

		//crer un tableau de paramtres transmis  la fonction
		var params = [
			new SOAPParameter(parentTaskId, "parentTaskId"),
			new SOAPParameter(taskName, "taskName"),
			new SOAPParameter(projectIndicator, "projectIndicator"),
			new SOAPParameter(priority, "priority"),
			new SOAPParameter(status, "status"),
			new SOAPParameter(deadline, "deadline"),
			new SOAPParameter(description, "description")
		];

		//appeler les fonctions dans le service Web
		soapCall.encode(0, "AddTask", null, 0, null, params.length, params);
		soapCall.invoke();

	} catch(e) {
		alert(e);
	}	
}

//supprimer un projet ou une tche
function deleteTask(taskId)
{
	//ajouter le droit de communiquer avec le service Web pendant l'appel de cette fonction
	try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
	} catch (e) {
		alert(e);
		return null;
	}

	try
	{
		//crer un objet SOAPCall permettant de communiquer avec le service Web
		var soapCall = new SOAPCall();
		soapCall.transportURI = "http://" + taskPlannerServer + "/taskplanner/"+lang+"/TaskPlannerWS.php";

		//crer un tableau de paramtres transmis  la fonction
		var params = [new SOAPParameter(taskId, "taskId")];

		//appeler la fonction dans le service Web
		soapCall.encode(0, "DeleteTask", null, 0, null, params.length, params);
		soapCall.invoke();

	} catch(e) {
		alert(e);
	}	
}

//actualiser un projet ou une tche
function updateTask(taskId, taskName, projectIndicator, priority, status, deadline, description)
{
	//ajouter le droit de communiquer avec le service Web pendant l'appel de cette fonction
	try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
	} catch (e) {
		alert(e);
		return null;
	}

	try
	{
		//crer un objet SOAPCall permettant de communiquer avec le service Web
		var soapCall = new SOAPCall();
		soapCall.transportURI = "http://" + taskPlannerServer + "/taskplanner/"+lang+"/TaskPlannerWS.php";

		//crer un tableau de paramtres transmis  la fonction
		var params = [
			new SOAPParameter(taskId, "taskId"),
			new SOAPParameter(taskName, "taskName"),
			new SOAPParameter(projectIndicator, "projectIndicator"),
			new SOAPParameter(priority, "priority"),
			new SOAPParameter(status, "status"),
			new SOAPParameter(deadline, "deadline"),
			new SOAPParameter(description, "description")
		];

		//appeler la fonction dans le service Web
		soapCall.encode(0, "UpdateTask", null, 0, null, params.length, params);
		soapCall.invoke();

	} catch(e) {
		alert(e);
	}	
}

//fonctions retournant certaines proprits de l'arbre de projets 

//nombre de projets dans l'arbre
function getProjectCount() {
	try {
		return tasksXmlDoc.evaluate("count(//task[@projectindicator = 1])", tasksXmlDoc, null, 1, null).numberValue;
	} catch(e) {
		alert(e);
	}
}

//nombre de tches pour un projet donn
function getTaskCountForCurrentProject(projectIdx) {
	try {
		return tasksXmlDoc.evaluate("count((//task[@projectindicator = 1])[" + (projectIdx + 1) + "]/task[@projectindicator = 0])", tasksXmlDoc, null, 1, null).numberValue;
	} catch(e) {
		alert(e);
	}	
}


//affichage de la description de la tche
function showTaskDescription(taskIdx) {
	try {
		document.getElementById('description').value = tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (currentProjectIdx + 1) + "]/task[@projectindicator = 0][" + (taskIdx + 1) + "]/@description", tasksXmlDoc, null, 2, null).stringValue;
	} catch(e) {
		alert(e);
	}
}

//affichage de la description du projet 
function showProjectDescription(projectIdx) {
	try {
		document.getElementById('description').value = tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (projectIdx + 1)+ "]/@description", tasksXmlDoc, null, 2, null).stringValue;
	} catch(e) {
		alert(e);
	}
}

//crer un document XML  partir de la chane de caractres donne
function loadXmlFromString(stringXml) {
	
	try {
	
		var xmlParser = new DOMParser();
		return xmlParser.parseFromString(stringXml, "text/xml");
	} catch(e) {
		alert(e);
	}
}

//configurer les contrles dans la bote de dialogue "addtask" selon l'opration slectionne 
function initializeWidgets() {
	try {
	
		//sparer les paramtres slectionns
		var paramArray = location.search.substring(1).split('&');
	
		//vrifier le type de l'opration slectionne 
		if(paramArray[0] == "type=update") {
			//opration slectionne  actualiser la tche existante  configurer les valeurs 
			//des contrles sur les valeurs propres  la tche choisie pour actualiser
			var currentTaskIdx = window.opener.document.getElementById("task-tree").currentIndex;
			document.getElementById("taskname").value = window.opener.tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (window.opener.currentProjectIdx + 1) + "]/task[@projectindicator = 0][" + (currentTaskIdx + 1) + "]/@taskname", window.opener.tasksXmlDoc, null, 2, null).stringValue;
			document.getElementById("taskdescription").value = window.opener.tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (window.opener.currentProjectIdx + 1) + "]/task[@projectindicator = 0][" + (currentTaskIdx + 1) + "]/@description", window.opener.tasksXmlDoc, null, 2, null).stringValue;

			document.getElementById("status").selectedIndex = window.opener.tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (window.opener.currentProjectIdx + 1) + "]/task[@projectindicator = 0][" + (currentTaskIdx + 1) + "]/@statusid", window.opener.tasksXmlDoc, null, 1, null).numberValue - 1;
			document.getElementById("priority").selectedIndex = window.opener.tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (window.opener.currentProjectIdx + 1) + "]/task[@projectindicator = 0][" + (currentTaskIdx + 1) + "]/@priorityid", window.opener.tasksXmlDoc, null, 1, null).numberValue - 1;

			var deadline = window.opener.tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (window.opener.currentProjectIdx + 1) + "]/task[@projectindicator = 0][" + (currentTaskIdx + 1) + "]/@deadline", window.opener.tasksXmlDoc, null, 2, null).stringValue;

			setDate(new Date(deadline.substring(0, 4), deadline.substring(5, 7) - 1, deadline.substring(8, 10)));

			//activer la fonction  appeler si les valeurs saisies sont acceptes
			document.getElementById("addtask").setAttribute('ondialogaccept', 'return doUpdateTaskOK();');
		} else {
			//opration slectionne  crer une nouvelle tche  configurer les valeurs
			// des contrles par dfaut 
			var deadline = new Date();
			deadline.setDate(deadline.getDate() + 3);
	
			setDate(deadline);
			//configurer la fonction  appeler si les valeurs saisies sont acceptes
			document.getElementById("addtask").setAttribute('ondialogaccept', 'return doAddTaskOK();');
		}
	} catch(e) {
		alert(e);
	}
}

//configurer la date dans la bote de dialogue "addtask"
function setDate(deadline)
{

	//configurer le jour
	for(var day = 1; day <= 31; day++) {
		var dayStr = ("0" + day);
		var menuItem = document.getElementById("day").appendItem(dayStr.substring(dayStr.length - 2), day);

		if(day == deadline.getDate()) {
			document.getElementById("day").selectedItem = menuItem
		}
	}

	// configurer le mois
	for(var month = 1; month <= 12; month++) {
		var monthStr = ("0" + month);
		var menuItem = document.getElementById("month").appendItem(monthStr.substring(monthStr.length - 2), month);
				
		if(month == deadline.getMonth() + 1) {
			document.getElementById("month").selectedItem = menuItem
		}
	}

	// configurer l'anne
	for(var yearDsp = -1; yearDsp <= 4; yearDsp++) {
		var menuItem = document.getElementById("year").appendItem((new Date()).getFullYear() + yearDsp);
		if((new Date()).getFullYear() + yearDsp == deadline.getFullYear()) {
			document.getElementById("year").selectedItem = menuItem;
		}
	}

}

//vrifier les donnes saisies dans la bote de dialogue addtask
function ValidateData()
{
	// vrifier si le nom de la tche n'est pas vide
	if(document.getElementById("taskname").value.match(/^\s*$/) != null) {
		alert("Le nom de la tche ne peut pas tre vide");
		return false;
	}

	//vrifier si la date donne est correcte
	var tmpDate = new Date(document.getElementById("year").selectedItem.label, 
				document.getElementById("month").selectedItem.value - 1, 
				document.getElementById("day").selectedItem.value);

	if(tmpDate.getDate() != document.getElementById("day").selectedItem.value ||
		tmpDate.getMonth() + 1 != document.getElementById("month").selectedItem.value ||
		tmpDate.getFullYear() != document.getElementById("year").selectedItem.label) {

		alert("La date saisie n'est pas correcte");

		return false;
	}

	return true;
}

//ajouter une tche
function doAddTaskOK()
{	
	//vrifier les donnes
	if(ValidateData())
	{
		//donnes correctes  ajouter une tche  la base via le service Web
		var projectId = window.opener.tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (window.opener.currentProjectIdx + 1) + "]/@id", window.opener.tasksXmlDoc, null, 1, null).numberValue;


		addTask(projectId, 
			document.getElementById("taskname").value,
			0,
			document.getElementById("priority").selectedItem.value,
			document.getElementById("status").selectedItem.value,
			document.getElementById("year").selectedItem.label + "-" + document.getElementById("month").selectedItem.label + "-" + document.getElementById("day").selectedItem.label,
			document.getElementById("taskdescription").value);


		window.opener.refreshProjectTree(window.opener.currentProjectIdx);
	
		return true
	}
	
	return false;
}

//actualiser les informations sur la tche
function doUpdateTaskOK() {
	
	//vrifier les donnes
	if(ValidateData())
	{

		// donnes correctes  actualiser la tche dans la base via le service Web
		var taskId = window.opener.tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (window.opener.currentProjectIdx + 1) + "]/task[@projectindicator = 0][" + (window.opener.document.getElementById("task-tree").currentIndex + 1) + "]/@id", window.opener.tasksXmlDoc, null, 2, null).stringValue;

		updateTask(taskId, 
			document.getElementById("taskname").value,
			0,
			document.getElementById("priority").selectedItem.value,
			document.getElementById("status").selectedItem.value,
			document.getElementById("year").selectedItem.label + "-" + document.getElementById("month").selectedItem.label + "-" + document.getElementById("day").selectedItem.label,
			document.getElementById("taskdescription").value);


		window.opener.refreshProjectTree(window.opener.currentProjectIdx);
	
		return true;
	}
	
	return false;
}

//ajouter un nouveau projet 
function doAddProjectOK()
{	
	//vrifier le nom du projet 
	if(document.getElementById("taskname").value.match(/^\s*$/) != null) {
		alert("Le nom du projet ne peut pas tre vide");
		return false;
	}

	// ajouter un projet  la base via le service Web
	var parentProjectId = window.opener.tasksXmlDoc.evaluate("(//task[@projectindicator = 1])[" + (window.opener.currentProjectIdx + 1) + "]/@id", window.opener.tasksXmlDoc, null, 1, null).numberValue;

	addTask(parentProjectId, 
		document.getElementById("taskname").value, 
		1,
		-1,
		-1,
		"",
		document.getElementById("taskdescription").value);

	window.opener.refreshProjectTree(window.opener.currentProjectIdx);
	
	return true;
}