<?php
/* classe d'aide qui facilite la conversion des chanes de caractres en format conforme au standard XML */
class XmlAux
{
    function EscapeString($inputStr)
    {
	return htmlspecialchars(XmlAux::html_entity_decode($inputStr, ENT_QUOTES), ENT_QUOTES);
    }
    
    function html_entity_decode($inputStr, $quoteStyle = ENT_QUOTES)
    {
	$transTable = get_html_translation_table(HTML_SPECIALCHARS, $quoteStyle);
	
	if($transTable["'"] != '&#039;')
	{
	    $transTable["'"] = '&#039;';
	}
	
	return strtr($inputStr, array_flip($transTable));
	
    }
}
?>
