<?
require_once('lib/XmlAux.php');

/* classe qui dissimule les dtails d'implmentation d'accs  la base de donnes PostgreSql */

class PgSQLQuery
{
	var $dbHandle; /* objet d'accs  la base */

	/* constructeur qui ouvre la connexion  la base de donnes */
	function PgSQLQuery($connString)
	{
		$this->dbHandle = pg_connect($connString);
		if(!$this->dbHandle)
		{
		 	die(pg_errormessage());
		}
	}
	
	/* fermer la connexion  la base de donnes */
	function CloseDB()
	{
		if($this->dbHandle)
		{
			pg_close($this->dbHandle);
		}
	}

	/* appeler une requte SQL dans la base de donnes et retourner comme rsultat une valeur scalaire */
	function ExecuteScalar($query, $row, $column)
	{
		$result = pg_exec($this->dbHandle, $query);
		if($this->GetNumRows($result) > 0)
		{
			return $this->GetScalar($result, $row, $column);
		}
			
		return NULL;
	}
	
	/* appeler une requte SQL dans la base de donnes sans retourner de rsultat */
	function Execute($query)
	{
	    $result = pg_exec($this->dbHandle, $query);
	    if($this->GetNumRows($result) > 0)
	    {
		pg_free_result($result);
	    }
	}
	
	/* appeler une requte SQL dans la base de donnes et retourner un rsultat */
	function ExecuteResultSet($query)
	{
	    return pg_exec($this->dbHandle, $query);
	}
		
	/* appeler une requte SQL dans la base de donnes et retourner un document XML, cr selon l'ensemble de rsultats retourn */
	function ExecuteXml($query, $rootNode = null)
	{
	    $result = $this->ExecuteResultSet($query);
		    
	    if($rootNode != null)
	    {
    		$resXml = "<".$rootNode.">";
	    }
		    
	    $numRows = $this->GetNumRows($result);
	    $numCols = $numRows > 0 ? $this->GetNumCols($result): -1;
	
	    /* crer des nuds dans le document XML, correspondant aux lignes du rsultat retourn  */
	    for($rowIdx = 0; $rowIdx < $numRows; $rowIdx++)
	    {
		$resXml .= "<row ".GenerateRowAttribs($result, $rowIdx) . " />";
	    }
		    
	    if($rootNode != null)
	    {
		$resXml .= "</".$rootNode.">";
	    }
	    
	    return $resXml;		    
	}	
	
	/* retourner le nombre des lignes du rsultat */
	function GetNumRows($result)
	{
	    return pg_numrows($result);
	}
	
	/*retourner le nombre des colonnes du rsultat */
	function GetNumCols($result)
	{
	    return pg_numfields($result);
	}
	
	/* tlcharger une valeur scalaire  partir du rsultat */
	function GetScalar($result, $numRow, $numCol)
	{
	    return pg_result($result, $numRow, $numCol);
	}
	
	/* gnrer les attributs du nud du document XML selon la ligne du rsultat retourn  */
	function GenerateRowAttribs($result, $rowIdx)
	{
	    for($colIdx = 0; $colIdx < $this->GetNumCols($result); $colIdx++)
	    {
	        if(pg_fieldisnull($result, $rowIdx, $colIdx) == 0)
	        {
		    $resXml .= pg_fieldname($result, $colIdx)."=\"".XmlAux::EscapeString(pg_result($result, $rowIdx, $colIdx))."\" ";
		}
	    }
	    
	    return $resXml;
	}
}
?>
