<?php

/* taskplanner webservice */

/* joindre les fichiers demands */
    require('conf.php');
    require('lib/nusoap.php');
    require('db/PgSQLQuery.php');
    require('db/MySQLQuery.php');
    require('db/TaskPlannerDB.php');    

/* crer un serveur */        
    $s = new soap_server;
    
/* enregistrer les fonctions proposes */
    $s->register('GetTasks');
    $s->register('AddTask');
    $s->register('DeleteTask');
    $s->register('UpdateTask');
 
/* fonction d'aide qui cre un objet proposant
   des oprations lmentaires sur la base de donnes */
   
    function CreateTaskPlannerDB()
    {
	return strcmp(DBType, "PostgreSql") == 0 ?
	    new TaskPlannerDB(new PgSQLQuery(ConnectionString)) :
	    new TaskPlannerDB(new MySQLQuery(Host, DatabaseName, User, Password));
    }
    
/* chargement du document XML dcrivant les projets et les tches */
    function GetTasks($parentTaskId)
    {	
	$taskPlannerDB = CreateTaskPlannerDB();
	return $taskPlannerDB->GetTasks();
    }

/* ajouter une tche ou un projet */    
    function AddTask($parentTaskId, $taskName, $projectindicator, $priority, $status, $deadline, $description)
    {
	$priority = $priority == -1 ? null : $priority;
	$status = $status == -1 ? null : $status;	

	$deadline = ereg("^[0-9]{4}-[0-9]{2}-[0-9]{2}$", $deadline) ? $deadline : null;

	$taskPlannerDB = CreateTaskPlannerDB();
	return $taskPlannerDB->AddTask($parentTaskId, $taskName, $projectindicator, $priority, $status, $deadline, $description);
    }
    
/* supprimer un projet ou une tche */
    function DeleteTask($taskId)
    {
	$taskPlannerDB = CreateTaskPlannerDB();
	$taskPlannerDB->DeleteTask($taskId);
    }
    
/* actualiser un projet ou une tche */
    function UpdateTask($taskId, $taskName, $projectindicator, $priority, $status, $deadline, $description)
    {
    	$priority = $priority == -1 ? null : $priority;
	$status = $status == -1 ? null : $status;
	
	$deadline = ereg("^[0-9]{4}-[0-9]{2}-[0-9]{2}$", $deadline) ? $deadline : null;

	$taskPlannerDB = CreateTaskPlannerDB();
	return $taskPlannerDB->UpdateTask($taskId, $taskName, $projectindicator, $priority, $status, $deadline, $description);
    }
    
/* effectuer une fonction souhaite */
    $s->service($HTTP_RAW_POST_DATA);
?>
